## 域名展示项目

![2025_234221.webp](/Source-Code/DomainDisplay/2025_234221.webp)

这是一个用于展示域名列表的网页应用，支持多种筛选和展示方式。

## 运行
- python -m http.server 3000


## 最近更新

### 友情链接功能

- 在页面底部添加了友情链接展示区域
- 友情链接以卡片式布局展示，更加美观
- 每个链接显示网站首字母图标，并配有独特的颜色标识
- 友情链接通过JSON配置文件进行管理
- 支持自定义友情链接标题、显示/隐藏状态
- 每个链接支持名称、网址和描述配置
- 链接在鼠标悬停时显示特效，提升用户体验
- 自动适配夜间模式，保持整体风格一致
- 移动端自适应优化，确保在各种设备上正常显示

### 展示方式切换功能

- 在页面左上角添加了展示方式切换按钮，可快速切换"分组"和"卡片"两种展示方式
- 切换按钮会根据当前展示方式显示不同图标（分组显示网格图标，卡片显示列表图标）
- 展示方式状态会保存在本地存储中，下次访问时自动应用
- 展示方式可通过JSON配置默认值（1为分组视图，2为卡片视图）
- 切换过程无需刷新页面，实现流畅切换体验

### 夜间模式功能

- 添加了夜间模式切换功能，位于页面右上角
- 夜间模式状态会保存在本地存储中，下次访问时自动应用
- 夜间模式可通过JSON配置默认值（0为白天模式，1为夜间模式）
- 优化了夜间模式下的所有UI元素，包括卡片、按钮、文字等
- 夜间模式下二维码模态框也有专门的暗色主题

### 页面标题动态配置

- 页面标题现在完全由JSON配置控制，无需修改HTML
- 通过"页面标题文本"字段可设置页面显示的标题
- 支持与浏览器标题栏标题不同的设置

### 移动端适配优化

- 优化了域名卡片在移动设备上的显示效果
- 增加了多级断点适配（1200px、992px、768px、576px、380px）
- 添加了横屏模式优化，提高屏幕利用率
- 调整了字体大小和内边距，使内容在小屏幕上更加清晰可见
- 为特小屏幕设备（≤380px）添加了额外的样式优化

### 注册商图标改进

- 将注册商图标改为显示注册商名称的首字母或中文字符
- 为每个注册商分配固定的背景颜色，不再随机变化
- 优化了图标样式，使其更适合显示中文字符
- 为常见注册商（GoDaddy、Namecheap、阿里云、西部数码等）分配了特定颜色
- 对于新增注册商，会通过算法自动分配固定颜色

### 筛选功能增强

- 将注册商筛选和后缀筛选改为动态填充，自动包含所有数据中的选项
- 为"西部数码"等新增注册商添加了特定的卡片背景样式
- 优化了筛选器在移动设备上的显示效果

### 触摸设备优化

- 针对触摸设备添加了特定的交互优化
- 优化了高像素密度屏幕的显示效果
- 添加了触摸反馈效果

## 使用方法

1. 在浏览器中打开 `index.html` 文件
2. 使用顶部的标签和筛选器筛选域名
3. 点击"购买"按钮查看二维码支付信息
4. 点击右上角的图标切换夜间模式

## 技术栈

- HTML5
- CSS3（响应式设计）
- JavaScript（原生）

## 数据格式

域名数据存储在 `domains.json` 文件中，格式如下：

```json
{
  "网站配置": {
    "标题": "域名展示",
    "显示标题": 1,
    "页面标题文本": "我的域名",
    "图标": "images/favicon.svg",
    "夜间模式": 0,
    "夜间模式列表": [
      {
        "id": 0,
        "名称": "白天模式",
        "描述": "浅色背景，深色文字，适合日间浏览"
      },
      {
        "id": 1,
        "名称": "夜间模式",
        "描述": "深色背景，浅色文字，减少夜间视觉疲劳"
      }
    ],
    "展示方式": {
      "当前模式": 1,
      "模式列表": [
        {
          "id": 1,
          "名称": "分组视图",
          "描述": "按域名后缀分组展示"
        },
        {
          "id": 2,
          "名称": "卡片视图",
          "描述": "平铺展示所有域名卡片"
        }
      ]
    },
    "界面设置": {
      "统计卡片": { /* 配置... */ },
      "筛选条件": { /* 配置... */ },
      "友情链接": {
        "显示": 1,
        "标题": "友情链接",
        "链接列表": [
          {
            "名称": "阿里云",
            "网址": "https://www.aliyun.com",
            "描述": "阿里云官网"
          },
          {
            "名称": "腾讯云",
            "网址": "https://cloud.tencent.com",
            "描述": "腾讯云官网"
          }
          // 更多链接...
        ]
      }
    }
    // 其他配置...
  },
  "域名列表": [
    {
      "id": 1,
      "前缀": "example",
      "后缀": ".com",
      "注册商": "GoDaddy",
      "到期": "2025-12-31",
      "价格": 12.99,
      "可购买": "是/否",
      "非卖": "是/否"
    },
    // 更多域名...
  ]
}
```

## 自定义配置

您可以通过修改 `domains.json` 文件中的 `网站配置` 部分来自定义网站的外观和行为。

## 功能实现

1. **域名数据展示**
   - 支持两种展示方式：按后缀分组展示和卡片式平铺展示
   - 通过左上角按钮可随时切换展示方式
   - 展示方式通过JSON配置文件设置默认值，并记住用户选择
   - 每个分组有独特的标题和颜色标识
   - 保持原有域名卡片样式不变

2. **多层次筛选功能**
   - 域名状态筛选：全部/待售/已售/收藏
   - 注册商筛选：支持按注册商筛选
   - 域名后缀筛选：支持按后缀筛选
   - 可通过JSON配置控制筛选器的显示/隐藏（0为隐藏，1为显示）

3. **数据统计**
   - 总域名数量统计
   - 待售域名数量统计
   - 已售域名数量统计
   - 可通过JSON配置控制统计卡片的显示/隐藏（0为隐藏，1为显示）

4. **用户交互**
   - 左上角展示方式切换按钮
   - 右上角夜间模式切换按钮
   - 域名购买按钮
   - 二维码支付模态框
   - 响应式设计，适配不同设备

5. **数据管理**
   - 使用JSON文件存储域名数据
   - 支持动态读取和渲染域名信息

6. **前端实现**
   - 采用HTML5、CSS3、原生JavaScript开发
   - 使用Font Awesome图标库增强UI效果
   - 采用Grid和Flex布局实现响应式设计

7. **分组展示实现**
   - 使用JavaScript对域名数据按后缀进行分组
   - 每个后缀组有独立的样式和图标

8. **展示方式配置**
   - 通过左上角按钮快速切换展示方式
   - 通过JSON配置文件设置默认展示方式
   - 支持分组展示(模式1)和卡片展示(模式2)
   - 采用CSS类切换控制不同展示模式的样式
   - 使用本地存储记住用户选择

9. **界面元素配置**
   - 通过JSON配置文件控制界面元素的显示/隐藏
   - 使用数字格式配置：0表示隐藏，1表示显示
   - 网站标题可控制显示/隐藏和内容
   - 统计卡片可单独设置显示/隐藏状态
   - 筛选标签和筛选器可单独设置显示/隐藏状态
   - 支持动态更改元素标题和图标

10. **夜间模式实现**
    - 使用CSS变量定义颜色方案
    - 通过classList切换应用不同的样式
    - 使用localStorage保存用户偏好
    - 通过JSON配置设置默认模式

11. **友情链接实现**
    - 通过JSON配置文件管理友情链接列表
    - 支持通过JSON配置控制显示/隐藏状态
    - 使用Flexbox布局实现自适应排列
    - 适配夜间模式和移动设备
    - 支持自定义标题和链接描述

## 样式特点

1. **后缀分组样式**
   - 分组标题采用不同颜色边框标识不同后缀
   - 每个后缀组有独立的计数显示
   - 使用图标增强视觉效果

2. **域名卡片样式**
   - 卡片式设计，带有阴影和悬停效果
   - 不同状态域名有差异化标识
   - 收藏域名有特殊样式

3. **响应式设计**
   - 桌面端每行显示3个域名卡片
   - 平板端每行显示2个域名卡片
   - 移动端每行显示1个域名卡片

4. **夜间模式样式**
   - 深色背景，浅色文字
   - 降低对比度，减少视觉疲劳
   - 所有UI元素都有专门的夜间模式样式

## 未来优化方向

1. 增加域名搜索功能
2. 添加排序功能（按价格、名称等）
3. 优化移动端交互体验
4. 增加更多域名数据统计维度
5. 添加用户登录和收藏管理功能
6. 增加自动夜间模式（根据系统设置或时间自动切换）
